import sys
from PyQt5.QtWidgets import QApplication, QWidget, QPushButton, QVBoxLayout

class TestWindow(QWidget):
    def __init__(self):
        super().__init__()
        self.initUI()

    def initUI(self):
        self.setWindowTitle('Test Window')
        layout = QVBoxLayout()
        btn = QPushButton('Click me', self)
        btn.clicked.connect(self.on_click)
        layout.addWidget(btn)
        self.setLayout(layout)
        self.setGeometry(300, 300, 250, 150)

    def on_click(self):
        print('Button clicked!')

if __name__ == '__main__':
    app = QApplication(sys.argv)
    test_window = TestWindow()
    test_window.show()
    sys.exit(app.exec_())